SELECT 
    N_NAME, 
    SUM(DISCOUNT_PRICE(L_EXTENDEDPRICE, L_DISCOUNT)) AS REVENUE
FROM 
    CUSTOMER, 
    ORDERS, 
    LINEITEM, 
    SUPPLIER, 
    NATION, 
    REGION
WHERE 
    C_CUSTKEY = O_CUSTKEY 
    AND L_ORDERKEY = O_ORDERKEY 
    AND L_SUPPKEY = S_SUPPKEY 
    AND C_NATIONKEY = S_NATIONKEY 
    AND S_NATIONKEY = N_NATIONKEY 
    AND N_REGIONKEY = R_REGIONKEY 
    AND Q5CONDITIONS(R_NAME, O_ORDERDATE) = 1
GROUP BY 
    N_NAME
ORDER BY 
    REVENUE DESC NULLS LAST;